/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.hopssslchecks;

import io.hops.security.CertificateLocalization;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.net.hopssslchecks.SSLMaterialAlreadyConfiguredException;
import org.apache.hadoop.security.UserGroupInformation;

public abstract class AbstractHopsSSLCheck
implements HopsSSLCheck,
Comparable<HopsSSLCheck> {
    private final Integer priority;

    public AbstractHopsSSLCheck(Integer priority) {
        this.priority = priority;
    }

    @Override
    public abstract HopsSSLCryptoMaterial check(UserGroupInformation var1, Set<String> var2, Configuration var3, CertificateLocalization var4) throws IOException;

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(HopsSSLCheck hopsSSLCheck) {
        if (this.priority < hopsSSLCheck.getPriority()) {
            return 1;
        }
        if (this.priority > hopsSSLCheck.getPriority()) {
            return -1;
        }
        return 0;
    }

    protected void isConfigurationNeededForSuperUser(String username, Configuration configuration) throws SSLMaterialAlreadyConfiguredException {
        if (this.isCryptoMaterialSet(configuration) && !configuration.getBoolean("client.rpc.ssl.force.configure", false)) {
            throw new SSLMaterialAlreadyConfiguredException("Crypto material for user <" + username + "> has already been configured");
        }
    }

    private boolean isCryptoMaterialSet(Configuration conf) {
        for (HopsSSLSocketFactory.CryptoKeys key : HopsSSLSocketFactory.CryptoKeys.values()) {
            String propValue = conf.get(key.getValue(), key.getDefaultValue());
            if (!this.checkForDefaultInProperty(key, propValue)) continue;
            return false;
        }
        return true;
    }

    private boolean checkForDefaultInProperty(HopsSSLSocketFactory.CryptoKeys key, String propValue) {
        return key.getType() != HopsSSLSocketFactory.PropType.LITERAL && key.getDefaultValue().equals(propValue);
    }

    private boolean checkUsernameInProperty(String username, String propValue, HopsSSLSocketFactory.PropType propType) {
        if (propType == HopsSSLSocketFactory.PropType.FILEPATH) {
            return propValue.contains(username);
        }
        return true;
    }

    private boolean isHostnameInCryptoMaterial(String hostname, Configuration configuration) {
        for (HopsSSLSocketFactory.CryptoKeys key : HopsSSLSocketFactory.CryptoKeys.values()) {
            String propValue = configuration.get(key.getValue(), key.getDefaultValue());
            if (key.getType() != HopsSSLSocketFactory.PropType.FILEPATH || propValue.contains(hostname)) continue;
            return false;
        }
        return true;
    }
}

