/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;
import org.apache.hadoop.util.envVars.EnvironmentVariables;
import org.apache.hadoop.util.envVars.EnvironmentVariablesFactory;

public class SuperuserKeystoresLoader {
    private static final Log LOG = LogFactory.getLog(SuperuserKeystoresLoader.class);
    public static final String SUPER_MATERIAL_DIRECTORY_ENV_VARIABLE = "SUPERUSER_MATERIAL_DIRECTORY";
    protected static final String SUPER_MATERIAL_HOME_SUBDIRECTORY = ".hops_tls";
    private static final String SUPER_KEYSTORE_FILE_FORMAT = "%s__kstore.jks";
    private static final String SUPER_TRUSTSTORE_FILE_FORMAT = "%s__tstore.jks";
    private static final String SUPER_MATERIAL_PASSWD_FILE_FORMAT = "%s__passwd";
    private static final Pattern HOME_PATTERN = Pattern.compile(".*\\$\\{HOME\\}.*");
    private static final Pattern HOME_REPLACEMENT_PATTERN = Pattern.compile("\\$\\{HOME\\}");
    private static final Pattern USER_PATTERN = Pattern.compile(".*\\$\\{USER\\}.*");
    private static final Pattern USER_REPLACEMENT_PATTERN = Pattern.compile("\\$\\{USER\\}");
    private final Configuration configuration;
    private final EnvironmentVariables environmentVariables;

    public SuperuserKeystoresLoader(Configuration configuration) {
        this.configuration = configuration;
        this.environmentVariables = EnvironmentVariablesFactory.getInstance();
    }

    public X509SecurityMaterial loadSuperUserMaterial(String username) throws IOException {
        Path superMaterialDirectory = this.getMaterialDirectory(username);
        Path keystore = superMaterialDirectory.resolve(this.getSuperKeystoreFilename(username));
        Path truststore = superMaterialDirectory.resolve(this.getSuperTruststoreFilename(username));
        Path password = superMaterialDirectory.resolve(this.getSuperMaterialPasswdFilename(username));
        return new X509SecurityMaterial(keystore, truststore, password);
    }

    public X509SecurityMaterial loadSuperUserMaterial() throws IOException {
        String username = UserGroupInformation.getLoginUser().getUserName();
        return this.loadSuperUserMaterial(username);
    }

    private Path getMaterialDirectory(String username) throws IOException {
        String superuserMaterialDirectory = this.environmentVariables.getEnv(SUPER_MATERIAL_DIRECTORY_ENV_VARIABLE);
        if (superuserMaterialDirectory != null) {
            LOG.debug((Object)("Found environment variable for super user material directory. Path is " + superuserMaterialDirectory));
            return Paths.get(superuserMaterialDirectory, new String[0]);
        }
        superuserMaterialDirectory = this.environmentVariables.getEnv("MATERIAL_DIRECTORY");
        if (superuserMaterialDirectory != null) {
            LOG.debug((Object)("Found environment variable for material directory. Path is " + superuserMaterialDirectory));
            return Paths.get(superuserMaterialDirectory, new String[0]);
        }
        String userHome = System.getProperty("user.home");
        superuserMaterialDirectory = this.configuration.get("hops.tls.superuser-material-directory", null);
        if (!Strings.isNullOrEmpty((String)superuserMaterialDirectory)) {
            LOG.debug((Object)("Super user material directory has been set in configuration file " + superuserMaterialDirectory));
            Matcher matcher = HOME_PATTERN.matcher(superuserMaterialDirectory);
            if (matcher.matches()) {
                matcher = HOME_REPLACEMENT_PATTERN.matcher(superuserMaterialDirectory);
                String templatedDirectory = matcher.replaceAll(userHome);
                LOG.debug((Object)("Replacing ${HOME} - Super user material directory: " + templatedDirectory));
                return Paths.get(templatedDirectory, new String[0]);
            }
            matcher = USER_PATTERN.matcher(superuserMaterialDirectory);
            if (matcher.matches()) {
                matcher = USER_REPLACEMENT_PATTERN.matcher(superuserMaterialDirectory);
                String templatedDirectory = matcher.replaceAll(username);
                LOG.debug((Object)("Replacing ${USER} - Super user material directory: " + templatedDirectory));
                return Paths.get(templatedDirectory, new String[0]);
            }
            return Paths.get(superuserMaterialDirectory, new String[0]);
        }
        Path path = Paths.get(userHome, SUPER_MATERIAL_HOME_SUBDIRECTORY);
        LOG.debug((Object)("Falling back to $HOME for super user material directory: " + path));
        return path;
    }

    @VisibleForTesting
    public String getSuperKeystoreFilename(String username) {
        return String.format(SUPER_KEYSTORE_FILE_FORMAT, username);
    }

    @VisibleForTesting
    public String getSuperTruststoreFilename(String username) {
        return String.format(SUPER_TRUSTSTORE_FILE_FORMAT, username);
    }

    @VisibleForTesting
    public String getSuperMaterialPasswdFilename(String username) {
        return String.format(SUPER_MATERIAL_PASSWD_FILE_FORMAT, username);
    }
}

