/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.persistence;

import io.hops.hopsworks.persistence.entity.pki.PKICertificate;
import io.hops.hopsworks.persistence.entity.pki.PKICertificateId;
import jakarta.ejb.Stateless;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Optional;

@Stateless
public class PKICertificateFacade {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public PKICertificate findBySerialNumber(Long serialNumber) {
        return (PKICertificate)this.em.createNamedQuery("PKICertificate.findBySerialNumber", PKICertificate.class).setParameter("serialNumber", (Object)serialNumber).getSingleResult();
    }

    public Optional<PKICertificate> findBySubjectAndStatus(String subject, PKICertificate.Status status) {
        try {
            return Optional.of((PKICertificate)this.em.createNamedQuery("PKICertificate.findByStatusAndSubject", PKICertificate.class).setParameter("subject", (Object)subject).setParameter("status", (Object)status).getSingleResult());
        }
        catch (NoResultException ex) {
            return Optional.empty();
        }
    }

    public List<String> findAllSubjectsWithStatusAndPartialSubject(String partialSubject, PKICertificate.Status status) {
        return this.em.createNamedQuery("PKICertificate.findSubjectByStatusAndPartialSubject", String.class).setParameter("subject", (Object)partialSubject).setParameter("status", (Object)status).getResultList();
    }

    public void saveCertificate(PKICertificate certificate) {
        this.em.persist((Object)certificate);
    }

    public Optional<PKICertificate> findById(PKICertificateId id) {
        return Optional.ofNullable((PKICertificate)this.em.find(PKICertificate.class, (Object)id));
    }

    public void updateCertificate(PKICertificate certificate) {
        this.em.merge((Object)certificate);
    }

    public void deleteCertificate(PKICertificate certificate) {
        this.em.remove(this.em.merge((Object)certificate));
    }
}

