/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.persistence;

import io.hops.hopsworks.persistence.entity.pki.PKIKey;
import jakarta.ejb.Stateless;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import java.util.logging.Level;
import java.util.logging.Logger;

@Stateless
public class KeyFacade {
    private static final Logger LOGGER = Logger.getLogger(KeyFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public byte[] getEncodedKey(String owner, PKIKey.Type type) {
        try {
            PKIKey key = (PKIKey)this.em.createNamedQuery("PKIKey.findById", PKIKey.class).setParameter("owner", (Object)owner).setParameter("type", (Object)type).getSingleResult();
            return key.getKey();
        }
        catch (NoResultException ex) {
            LOGGER.log(Level.INFO, "There is no " + String.valueOf(type) + " key for " + owner);
            return null;
        }
    }

    public void saveKey(PKIKey key) {
        this.em.persist((Object)key);
    }
}

