/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.persistence;

import io.hops.hopsworks.persistence.entity.pki.CAType;
import io.hops.hopsworks.persistence.entity.pki.PKICrl;
import jakarta.ejb.Stateless;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

@Stateless
public class CRLFacade {
    private static final Logger LOGGER = Logger.getLogger(CRLFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public boolean exist(CAType type) {
        try {
            this.em.createNamedQuery("PKICrl.forCAType", PKICrl.class).setParameter("type", (Object)type).getSingleResult();
            return true;
        }
        catch (NoResultException ex) {
            return false;
        }
    }

    public Optional<PKICrl> getCRL(CAType type) {
        try {
            return Optional.of((PKICrl)this.em.createNamedQuery("PKICrl.forCAType", PKICrl.class).setParameter("type", (Object)type).getSingleResult());
        }
        catch (NoResultException ex) {
            LOGGER.log(Level.SEVERE, "Could not find CRL for CA type: " + String.valueOf(type));
            return Optional.empty();
        }
    }

    public void init(PKICrl crl) {
        this.em.persist((Object)crl);
    }

    public void update(PKICrl crl) {
        this.em.merge((Object)crl);
    }
}

