/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.configuration;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.hops.hopsworks.ca.configuration.UsernamesConfiguration;
import io.hops.hopsworks.persistence.entity.util.Variables;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.ConcurrencyManagementType;
import jakarta.ejb.Singleton;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class UsernamesConfiguration {
    private static final String UNIX_USERNAMES_VARIABLE = "unix_usernames_conf";
    private Map<String, String> unixUsernames = new HashMap();
    private Map<String, String> inverseUnixUsernames = new HashMap();
    private final Gson gson = new Gson();
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @PostConstruct
    public void init() {
        this.populateDefaultValues();
        Variables v = (Variables)this.em.find(Variables.class, (Object)"unix_usernames_conf");
        if (v != null) {
            String rawValue = v.getValue();
            try {
                Map confUnixUsernames = (Map)this.gson.fromJson(rawValue, Map.class);
                for (Map.Entry k : confUnixUsernames.entrySet()) {
                    this.unixUsernames.put((String)k.getKey(), (String)k.getValue());
                    this.inverseUnixUsernames.put((String)k.getValue(), (String)k.getKey());
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
    }

    private void populateDefaultValues() {
        for (Username u : Username.values()) {
            this.unixUsernames.put(u.name().toLowerCase(), u._default);
            this.inverseUnixUsernames.put(u._default, u.name().toLowerCase());
        }
    }

    public String getUsername(Username username) {
        String configuredUsername = (String)this.unixUsernames.get(username.name().toLowerCase());
        if (configuredUsername != null) {
            return configuredUsername;
        }
        return username._default;
    }

    public String getNormalizedUsername(String username) {
        return (String)this.inverseUnixUsernames.get(username.toLowerCase());
    }
}

