/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.configuration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.hops.hopsworks.ca.configuration.CAConf;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.ConcurrencyManagementType;
import jakarta.ejb.Singleton;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class CAConf {
    private LoadingCache<CAConfKeys, String> caConfiguration;
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @PostConstruct
    public void init() {
        this.caConfiguration = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String get(CAConfKeys confKey) {
        try {
            return (String)this.caConfiguration.get((Object)confKey);
        }
        catch (ExecutionException e) {
            return confKey.getDefaultValue();
        }
    }

    public String getString(CAConfKeys confKey) {
        return this.get(confKey);
    }

    public Boolean getBoolean(CAConfKeys confKey) {
        return Boolean.valueOf(this.get(confKey));
    }

    public Integer getInt(CAConfKeys confKey) {
        return Integer.valueOf(this.get(confKey));
    }

    public Long getLong(CAConfKeys confKeys) {
        return Long.valueOf(this.get(confKeys));
    }
}

