/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.filter;

import io.hops.hopsworks.api.auth.Configuration;
import io.hops.hopsworks.api.auth.UserStatusValidator;
import io.hops.hopsworks.api.auth.UserUtilities;
import io.hops.hopsworks.api.auth.key.ApiKeyFilter;
import io.hops.hopsworks.api.auth.key.ApiKeyRequired;
import io.hops.hopsworks.api.auth.key.ApiKeyUtilities;
import io.hops.hopsworks.exceptions.ApiKeyException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiKey;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiScope;
import io.hops.hopsworks.restutils.RESTLogLevel;
import jakarta.annotation.Priority;
import jakarta.ejb.EJB;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;

@Provider
@ApiKeyRequired
@Priority(value=999)
public class CaApiKeyFilter
extends ApiKeyFilter {
    @EJB
    private UserStatusValidator userStatusValidator;
    @EJB
    private ApiKeyUtilities apiKeyUtilities;
    @EJB
    private UserUtilities userUtilities;
    @EJB
    private Configuration conf;
    @Context
    private ResourceInfo resourceInfo;

    protected void validateUserStatus(Users user) throws UserException {
        this.userStatusValidator.checkStatus(user.getStatus());
    }

    protected ApiKey getApiKey(String key) throws ApiKeyException {
        return this.apiKeyUtilities.getApiKey(key);
    }

    protected Set<ApiScope> getApiScopes(ApiKey key) {
        return this.apiKeyUtilities.getScopes(key);
    }

    protected List<String> getUserRoles(Users user) {
        return this.userUtilities.getUserRoles(user);
    }

    protected RESTLogLevel getRestLogLevel() {
        return this.conf.getLogLevel(Configuration.AuthConfigurationKeys.HOPSWORKS_REST_LOG_LEVEL);
    }

    protected Class<?> getResourceClass() {
        return this.resourceInfo.getResourceClass();
    }

    protected Method getResourceMethod() {
        return this.resourceInfo.getResourceMethod();
    }
}

