/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.certificates;

import io.hops.hopsworks.api.auth.key.ApiKeyRequired;
import io.hops.hopsworks.ca.api.filter.NoCacheResponse;
import io.hops.hopsworks.ca.controllers.PKI;
import io.hops.hopsworks.jwt.annotation.JWTRequired;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiScope;
import jakarta.ejb.EJB;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.logging.Level;
import java.util.logging.Logger;

@Path(value="/pki")
@Stateless
@JWTRequired(acceptedTokens={"services", "api"}, allowedUserRoles={"HOPS_ADMIN"})
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class PKIResource {
    private static final Logger LOGGER = Logger.getLogger(PKIResource.class.getName());
    @EJB
    private NoCacheResponse noCacheResponse;
    @EJB
    private PKI pki;

    @PUT
    @Path(value="/configuration")
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response reconfigure() {
        LOGGER.log(Level.INFO, "Loading PKI configuration");
        this.pki.configure();
        return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).build();
    }
}

