/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.certificates;

import com.google.common.base.Strings;
import io.hops.hopsworks.api.auth.key.ApiKeyRequired;
import io.hops.hopsworks.ca.api.certificates.CSRView;
import io.hops.hopsworks.ca.api.certificates.HostCertsResource;
import io.hops.hopsworks.ca.api.filter.NoCacheResponse;
import io.hops.hopsworks.ca.controllers.CAException;
import io.hops.hopsworks.ca.controllers.CAInitializationException;
import io.hops.hopsworks.ca.controllers.CertificateNotFoundException;
import io.hops.hopsworks.ca.controllers.CertificateType;
import io.hops.hopsworks.ca.controllers.PKI;
import io.hops.hopsworks.ca.controllers.PKIUtils;
import io.hops.hopsworks.jwt.annotation.JWTRequired;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiScope;
import io.hops.hopsworks.restutils.RESTCodes;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.OperatorCreationException;

@RequestScoped
@Tag(name="HostCertsResource", description="Manage host certificates")
public class HostCertsResource {
    private static final String REVOKE_CERTIFICATES_PATTERN = "^%s__.*__[0-9]+.*";
    private static final Logger LOGGER = Logger.getLogger(HostCertsResource.class.getName());
    @EJB
    private NoCacheResponse noCacheResponse;
    @EJB
    private PKIUtils pkiUtils;
    @EJB
    private PKI pki;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Sing Host CSR with IntermediateHopsCA", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=CSRView.class))}, description="CSRView")})
    @JWTRequired(acceptedTokens={"services"}, allowedUserRoles={"AGENT"})
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response signCSR(CSRView csrView) throws CAException {
        if (csrView == null || csrView.getCsr() == null || csrView.getCsr().isEmpty()) {
            throw new IllegalArgumentException("Empty CSR");
        }
        try {
            X509Certificate signedCert = this.pki.signCertificateSigningRequest(csrView.getCsr(), CertificateType.HOST, csrView.getRegion());
            String stringifiedCert = this.pkiUtils.convertToPEM((X509Extension)signedCert);
            Pair chainOfTrust = this.pki.getChainOfTrust(this.pkiUtils.getResponsibleCA(CertificateType.HOST));
            CSRView signedCsr = new CSRView(stringifiedCert, (String)chainOfTrust.getLeft(), (String)chainOfTrust.getRight());
            if (!Strings.isNullOrEmpty((String)csrView.getPrivateKey())) {
                PKIUtils.KeyStores keyStores = this.pkiUtils.createB64Keystores(csrView.getPrivateKey(), signedCert, this.pkiUtils.loadCertificate((String)chainOfTrust.getRight()), this.pkiUtils.loadCertificate((String)chainOfTrust.getLeft()));
                signedCsr.setKeyStore((String)keyStores.getKeyStore());
                signedCsr.setTrustStore((String)keyStores.getTrustStore());
                signedCsr.setPassword(new String(keyStores.getPassword()));
            }
            1 csrViewGenericEntity = new /* Unavailable Anonymous Inner Class!! */;
            return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).entity((Object)csrViewGenericEntity).build();
        }
        catch (CAInitializationException | IOException | GeneralSecurityException | OperatorCreationException ex) {
            throw this.pkiUtils.csrSigningExceptionConvertToCAException(ex, CertificateType.HOST);
        }
    }

    @DELETE
    @Operation(summary="Revoke Host certificate")
    @JWTRequired(acceptedTokens={"services"}, allowedUserRoles={"AGENT"})
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response revokeCertificate(@Parameter(description="Identifier of the Certificate to revoke", required=true) @QueryParam(value="certId") String certId, @Parameter(description="Flag whether certId is a full RFC4514 Distinguished Name string") @QueryParam(value="exact") Boolean exact) throws CAException {
        if (Strings.isNullOrEmpty((String)certId)) {
            throw new IllegalArgumentException("Empty certificate identifier");
        }
        ArrayList<X500Name> subjectsToRevoke = new ArrayList<X500Name>();
        try {
            if (!Boolean.TRUE.equals(exact)) {
                X500Name certificateName = this.pkiUtils.parseCertificateSubjectName(certId, CertificateType.HOST);
                List subjects = this.pkiUtils.findAllValidSubjectsWithPartialMatch(certificateName.toString());
                subjects.forEach(s -> subjectsToRevoke.add(new X500Name(s)));
            } else {
                subjectsToRevoke.add(new X500Name(certId));
            }
            if (subjectsToRevoke.isEmpty()) {
                throw new CertificateNotFoundException("Could not find a VALID certificate with ID: " + certId + " Is exact X509 Name: " + exact);
            }
            for (X500Name n : subjectsToRevoke) {
                this.pki.revokeCertificate(n, CertificateType.HOST);
            }
            return Response.ok().build();
        }
        catch (CAInitializationException | GeneralSecurityException | InvalidNameException ex) {
            throw this.pkiUtils.certificateRevocationExceptionConvertToCAException(ex, CertificateType.HOST);
        }
    }

    @Path(value="all")
    @DELETE
    @Operation(summary="Revoke all Host certificates")
    @JWTRequired(acceptedTokens={"services"}, allowedUserRoles={"AGENT"})
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response revokeCertificateGlob(@Parameter(description="Hostname of the node to revoke certificates for", required=true) @QueryParam(value="hostname") String hostname) throws CAException {
        if (Strings.isNullOrEmpty((String)hostname)) {
            throw new IllegalArgumentException("Empty hostname to revoke");
        }
        List subjectsToRevoke = this.pkiUtils.findAllHostCertificateSubjectsForHost(hostname);
        try {
            for (String subject : subjectsToRevoke) {
                this.pki.revokeCertificate(new X500Name(subject), CertificateType.HOST);
            }
            return Response.ok().build();
        }
        catch (CAInitializationException | GeneralSecurityException ex) {
            throw this.pkiUtils.certificateRevocationExceptionConvertToCAException(ex, CertificateType.HOST);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get chain of trust for this type of certificates")
    public Response getChainOfTrust() throws CAException {
        try {
            Pair chainOfTrust = this.pki.getChainOfTrust(this.pkiUtils.getResponsibleCA(CertificateType.HOST));
            CSRView csrView = new CSRView((String)chainOfTrust.getLeft(), (String)chainOfTrust.getRight());
            2 csrViewGenericEntity = new /* Unavailable Anonymous Inner Class!! */;
            return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).entity((Object)csrViewGenericEntity).build();
        }
        catch (CAInitializationException | IOException | GeneralSecurityException ex) {
            throw new CAException(RESTCodes.CAErrorCode.CA_INITIALIZATION_ERROR, Level.SEVERE, CertificateType.HOST, "Failed to get chain of trust", "Failed to get chain of trust for HOST certificates", ex);
        }
    }
}

