/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.certificates;

import io.hops.hopsworks.api.auth.key.ApiKeyRequired;
import io.hops.hopsworks.ca.api.certificates.AppCertsResource;
import io.hops.hopsworks.ca.api.certificates.CRLResource;
import io.hops.hopsworks.ca.api.certificates.CSRView;
import io.hops.hopsworks.ca.api.certificates.CertificatesResource;
import io.hops.hopsworks.ca.api.certificates.HostCertsResource;
import io.hops.hopsworks.ca.api.certificates.KubeCertsResource;
import io.hops.hopsworks.ca.api.certificates.ProjectCertsResource;
import io.hops.hopsworks.ca.api.filter.NoCacheResponse;
import io.hops.hopsworks.ca.controllers.CAException;
import io.hops.hopsworks.ca.controllers.PKI;
import io.hops.hopsworks.ca.controllers.PKIUtils;
import io.hops.hopsworks.jwt.annotation.JWTRequired;
import io.hops.hopsworks.persistence.entity.pki.PKICertificate;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiScope;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ejb.EJB;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;

@Path(value="/certificate")
@Stateless
@Tag(name="CertificatesResource", description="Certificate Management API")
public class CertificatesResource {
    @Inject
    private HostCertsResource hostCertsResource;
    @Inject
    private AppCertsResource appCertsResource;
    @Inject
    private KubeCertsResource kubeCertsResource;
    @Inject
    private ProjectCertsResource projectCertsResource;
    @Inject
    private CRLResource crlResource;
    @EJB
    private PKI pki;
    @EJB
    private PKIUtils pkiUtils;
    @EJB
    private NoCacheResponse noCacheResponse;

    @Path(value="/host")
    public HostCertsResource getHostCertsResource() {
        return this.hostCertsResource;
    }

    @Path(value="/app")
    public AppCertsResource getAppCertsResource() {
        return this.appCertsResource;
    }

    @Path(value="/kube")
    public KubeCertsResource getKubeCertsResource() {
        return this.kubeCertsResource;
    }

    @Path(value="/project")
    public ProjectCertsResource getProjectCertsResource() {
        return this.projectCertsResource;
    }

    @Path(value="/crl")
    public CRLResource getCrlResource() {
        return this.crlResource;
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @Operation(summary="Get x509 certificate in pem format", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=CSRView.class))}, description="CSRView")})
    @JWTRequired(acceptedTokens={"services", "api"}, allowedUserRoles={"HOPS_ADMIN"})
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"HOPS_ADMIN", "AGENT"})
    public Response getCertificate(@Parameter(description="X.500 name of the Certificate", required=true) @PathParam(value="name") String name, @Parameter(description="Status of certificate", required=true, schema=@Schema(allowableValues={"VALID, REVOKED, EXPIRED"})) @QueryParam(value="status") PKICertificate.Status status) throws CAException, IOException {
        try {
            X509Certificate certificate = this.pki.loadCertificate(name, status);
            String pemified = this.pkiUtils.convertToPEM((X509Extension)certificate);
            CSRView cert = new CSRView(pemified, null, null);
            1 csrViewGenericEntity = new /* Unavailable Anonymous Inner Class!! */;
            return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).entity((Object)csrViewGenericEntity).build();
        }
        catch (GeneralSecurityException ex) {
            throw this.pkiUtils.certificateLoadingExceptionConvertToCAException((Throwable)ex);
        }
    }

    @GET
    @Path(value="/ready")
    public Response caReady() {
        String ready = System.getProperty("io.hops.hopsworks.ca.readyToSign", "true");
        if (ready.equalsIgnoreCase("false")) {
            return Response.status((int)423).build();
        }
        return Response.ok().build();
    }
}

