/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.certificates;

import io.hops.hopsworks.ca.api.filter.NoCacheResponse;
import io.hops.hopsworks.ca.controllers.CAException;
import io.hops.hopsworks.ca.controllers.CAInitializationException;
import io.hops.hopsworks.ca.controllers.CertificateType;
import io.hops.hopsworks.ca.controllers.PKI;
import io.hops.hopsworks.persistence.entity.pki.CAType;
import io.hops.hopsworks.restutils.RESTCodes;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;

@RequestScoped
@Tag(name="CRLResource", description="Resource to download HopsCA Certificate Revocation Lists")
public class CRLResource {
    @EJB
    private PKI pki;
    @EJB
    private NoCacheResponse noCacheResponse;

    @GET
    @Path(value="/intermediate")
    @Produces(value={"application/octet-stream"})
    @Operation(description="Endpoint to download HopsCA intermediate CA Certificate Revocation List")
    public Response fetchCRL() throws CAException {
        try {
            String crl = this.pki.getCertificateRevocationListPEM(CAType.INTERMEDIATE);
            return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).entity((Object)crl).build();
        }
        catch (CAInitializationException | IOException | GeneralSecurityException ex) {
            throw new CAException(RESTCodes.CAErrorCode.CERTIFICATE_REVOCATION_LIST_READ, Level.SEVERE, CertificateType.APP, "Failed to read CRL", ex.getMessage(), ex);
        }
    }
}

