/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.ca.api.certificates;

import com.google.common.base.Strings;
import io.hops.hopsworks.api.auth.key.ApiKeyRequired;
import io.hops.hopsworks.ca.api.certificates.AppCertsResource;
import io.hops.hopsworks.ca.api.certificates.CSRView;
import io.hops.hopsworks.ca.api.filter.NoCacheResponse;
import io.hops.hopsworks.ca.controllers.CAException;
import io.hops.hopsworks.ca.controllers.CAInitializationException;
import io.hops.hopsworks.ca.controllers.CertificateType;
import io.hops.hopsworks.ca.controllers.PKI;
import io.hops.hopsworks.ca.controllers.PKIUtils;
import io.hops.hopsworks.jwt.annotation.JWTRequired;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiScope;
import io.hops.hopsworks.restutils.RESTCodes;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.operator.OperatorCreationException;

@RequestScoped
@Tag(name="AppCertsResource", description="Manage App certificates")
public class AppCertsResource {
    private static final Logger LOGGER = Logger.getLogger(AppCertsResource.class.getName());
    @EJB
    private PKI pki;
    @EJB
    private NoCacheResponse noCacheResponse;
    @EJB
    private PKIUtils pkiUtils;

    @Operation(summary="Sign App certificate with IntermediateHopsCA", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=CSRView.class))}, description="CSRView")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JWTRequired(acceptedTokens={"services"}, allowedUserRoles={"AGENT"})
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response signCSR(CSRView csrView) throws CAException {
        if (csrView == null || Strings.isNullOrEmpty((String)csrView.getCsr())) {
            throw new IllegalArgumentException("Empty CSR");
        }
        try {
            X509Certificate signedCert = this.pki.signCertificateSigningRequest(csrView.getCsr(), CertificateType.APP, null);
            String stringifiedCert = this.pkiUtils.convertToPEM((X509Extension)signedCert);
            Pair chainOfTrust = this.pki.getChainOfTrust(this.pkiUtils.getResponsibleCA(CertificateType.APP));
            CSRView signedCsr = new CSRView(stringifiedCert, (String)chainOfTrust.getLeft(), (String)chainOfTrust.getRight());
            1 csrViewGenericEntity = new /* Unavailable Anonymous Inner Class!! */;
            LOGGER.log(Level.FINE, "Signed certificate: " + stringifiedCert);
            return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).entity((Object)csrViewGenericEntity).build();
        }
        catch (CAInitializationException | IOException | GeneralSecurityException | OperatorCreationException ex) {
            throw this.pkiUtils.csrSigningExceptionConvertToCAException(ex, CertificateType.APP);
        }
    }

    @Operation(summary="Revoke App certificate")
    @DELETE
    @JWTRequired(acceptedTokens={"services"}, allowedUserRoles={"AGENT"})
    @ApiKeyRequired(acceptedScopes={ApiScope.AUTH}, allowedUserRoles={"AGENT"})
    public Response revokeCertificate(@Parameter(description="Identifier of the Certificate to revoke", required=true) @QueryParam(value="certId") String certId) throws CAException {
        if (Strings.isNullOrEmpty((String)certId)) {
            throw new IllegalArgumentException("Empty certificate identifier");
        }
        try {
            this.pki.revokeCertificate(certId, CertificateType.APP);
            return Response.ok().build();
        }
        catch (CAInitializationException | GeneralSecurityException | InvalidNameException ex) {
            throw this.pkiUtils.certificateRevocationExceptionConvertToCAException(ex, CertificateType.APP);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get chain of trust for this type of certificates")
    public Response getChainOfTrust() throws CAException {
        try {
            Pair chainOfTrust = this.pki.getChainOfTrust(this.pkiUtils.getResponsibleCA(CertificateType.APP));
            CSRView csrView = new CSRView((String)chainOfTrust.getLeft(), (String)chainOfTrust.getRight());
            2 csrViewGenericEntity = new /* Unavailable Anonymous Inner Class!! */;
            return this.noCacheResponse.getNoCacheResponseBuilder(Response.Status.OK).entity((Object)csrViewGenericEntity).build();
        }
        catch (CAInitializationException | IOException | GeneralSecurityException ex) {
            throw new CAException(RESTCodes.CAErrorCode.CA_INITIALIZATION_ERROR, Level.SEVERE, CertificateType.APP, "Failed to get chain of trust", "Failed to get chain of trust for APP certificates", ex);
        }
    }
}

