/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsfs.client;

import io.hops.hadoop.shaded.io.hops.security.HopsUtil;
import io.hops.hadoop.shaded.org.apache.hadoop.conf.Configuration;
import io.hops.hadoop.shaded.org.apache.hadoop.fs.FSDataInputStream;
import io.hops.hadoop.shaded.org.apache.hadoop.fs.FSDataOutputStream;
import io.hops.hadoop.shaded.org.apache.hadoop.fs.FileStatus;
import io.hops.hadoop.shaded.org.apache.hadoop.fs.Path;
import io.hops.hadoop.shaded.org.apache.hadoop.fs.permission.FsPermission;
import io.hops.hadoop.shaded.org.apache.hadoop.hdfs.DistributedFileSystem;
import io.hops.hadoop.shaded.org.apache.hadoop.util.envVars.EnvironmentVariablesFactory;
import io.hops.hopsfs.client.HopsFSInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.util.Progressable;

public class HopsFileSystem
extends FileSystem {
    private static final String HOPSFS_URI_SCHEME = "hopsfs";
    DistributedFileSystem dfs;

    public void initialize(URI uri, org.apache.hadoop.conf.Configuration conf) throws IOException {
        super.initialize(uri, conf);
        Configuration hopsConf = new Configuration();
        for (Map.Entry entry : conf) {
            hopsConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        System.setProperty("HOPS_USER_NAME", this.getHopsUserName(hopsConf));
        this.dfs = new DistributedFileSystem();
        this.dfs.initialize(uri, hopsConf);
    }

    private String getHopsUserName(Configuration conf) throws IOException {
        Object localizedKeystorePath;
        String configuredKeystorePath = conf.get("hops.ssl.keystore.name", "k_certificate");
        String configuredPasswordPath = conf.get("hops.ssl.keystores.passwd.name", "material_passwd");
        File localizedKeystore = new File(configuredKeystorePath);
        File localizedPassword = new File(configuredPasswordPath);
        if (!localizedKeystore.exists() || !localizedPassword.exists()) {
            String keystoreName = Paths.get(configuredKeystorePath, new String[0]).getFileName().toString();
            String passwordName = Paths.get(configuredPasswordPath, new String[0]).getFileName().toString();
            localizedKeystore = new File(keystoreName);
            localizedPassword = null;
            if (localizedKeystore.exists()) {
                localizedPassword = new File(keystoreName);
            } else {
                String pwd = EnvironmentVariablesFactory.getInstance().getEnv("PWD");
                if (pwd != null) {
                    localizedKeystorePath = Paths.get(pwd, keystoreName);
                    if (!localizedKeystorePath.toFile().exists()) {
                        LOG.error((Object)"No crypto material found in PWD");
                        throw new IOException("No crypto material found in PWD");
                    }
                    localizedKeystore = localizedKeystorePath.toFile();
                    localizedPassword = Paths.get(pwd, passwordName).toFile();
                }
            }
        }
        try {
            String password = HopsUtil.readCryptoMaterialPassword((File)localizedPassword);
            KeyStore trustStore = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream(localizedKeystore);
            localizedKeystorePath = null;
            try {
                trustStore.load(fis, password.toCharArray());
            }
            catch (Throwable throwable) {
                localizedKeystorePath = throwable;
                throw throwable;
            }
            finally {
                if (fis != null) {
                    if (localizedKeystorePath != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)localizedKeystorePath).addSuppressed(throwable);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)trustStore.getCertificate(alias);
                String name = HopsUtil.extractCNFromSubject((String)cert.getSubjectDN().getName());
                if (name == null) continue;
                return name;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new IOException(ex);
        }
        throw new IOException("Did not manage to extract name from certificate");
    }

    public org.apache.hadoop.fs.FileStatus getFileStatus(org.apache.hadoop.fs.Path f) throws IOException {
        FileStatus fileSta = this.dfs.getFileStatus(this.toHopsPath(f));
        return this.toFileStatus(fileSta);
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path f, org.apache.hadoop.fs.permission.FsPermission permission) throws IOException {
        return this.dfs.mkdirs(this.toHopsPath(f), this.toHopsPermission(permission));
    }

    public org.apache.hadoop.fs.Path getWorkingDirectory() {
        return this.toPath(this.dfs.getWorkingDirectory());
    }

    public void setWorkingDirectory(org.apache.hadoop.fs.Path new_dir) {
        this.dfs.setWorkingDirectory(this.toHopsPath(new_dir));
    }

    public org.apache.hadoop.fs.FileStatus[] listStatus(org.apache.hadoop.fs.Path f) throws FileNotFoundException, IOException {
        FileStatus[] status = this.dfs.listStatus(this.toHopsPath(f));
        org.apache.hadoop.fs.FileStatus[] result = new org.apache.hadoop.fs.FileStatus[status.length];
        for (int i = 0; i < status.length; ++i) {
            result[i] = this.toFileStatus(status[i]);
        }
        return result;
    }

    public boolean delete(org.apache.hadoop.fs.Path f, boolean recursive) throws IOException {
        return this.dfs.delete(this.toHopsPath(f), recursive);
    }

    public boolean rename(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst) throws IOException {
        return this.dfs.rename(this.toHopsPath(src), this.toHopsPath(dst));
    }

    public org.apache.hadoop.fs.FSDataOutputStream append(org.apache.hadoop.fs.Path f, int bufferSize, Progressable progress) throws IOException {
        FSDataOutputStream out = this.dfs.append(this.toHopsPath(f), bufferSize, this.toHopsProgressable(progress));
        return new org.apache.hadoop.fs.FSDataOutputStream((OutputStream)out, null);
    }

    public org.apache.hadoop.fs.FSDataOutputStream create(org.apache.hadoop.fs.Path f, org.apache.hadoop.fs.permission.FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FSDataOutputStream out = this.dfs.create(this.toHopsPath(f), this.toHopsPermission(permission), overwrite, bufferSize, replication, blockSize, this.toHopsProgressable(progress));
        return new org.apache.hadoop.fs.FSDataOutputStream((OutputStream)out, null);
    }

    public org.apache.hadoop.fs.FSDataInputStream open(org.apache.hadoop.fs.Path f, int bufferSize) throws IOException {
        FSDataInputStream in = this.dfs.open(this.toHopsPath(f), bufferSize);
        return new org.apache.hadoop.fs.FSDataInputStream((InputStream)new HopsFSInputStream(in));
    }

    public URI getUri() {
        return this.dfs.getUri();
    }

    private org.apache.hadoop.fs.FileStatus toFileStatus(FileStatus fileSta) throws IOException {
        org.apache.hadoop.fs.permission.FsPermission permission = new org.apache.hadoop.fs.permission.FsPermission(fileSta.getPermission().toShort());
        org.apache.hadoop.fs.Path symLink = fileSta.isSymlink() ? this.toPath(fileSta.getSymlink()) : null;
        org.apache.hadoop.fs.Path path = this.toPath(fileSta.getPath());
        return new org.apache.hadoop.fs.FileStatus(fileSta.getLen(), fileSta.isDirectory(), (int)fileSta.getReplication(), fileSta.getBlockSize(), fileSta.getModificationTime(), fileSta.getAccessTime(), permission, fileSta.getOwner(), fileSta.getGroup(), symLink, path);
    }

    private org.apache.hadoop.fs.Path toPath(Path p) {
        return p == null ? null : new org.apache.hadoop.fs.Path(p.toUri());
    }

    private Path toHopsPath(org.apache.hadoop.fs.Path p) {
        return p == null ? null : new Path(p.toUri());
    }

    private FsPermission toHopsPermission(org.apache.hadoop.fs.permission.FsPermission p) {
        return p == null ? null : new FsPermission(p.toShort());
    }

    private io.hops.hadoop.shaded.org.apache.hadoop.util.Progressable toHopsProgressable(final Progressable progress) {
        return progress == null ? null : new io.hops.hadoop.shaded.org.apache.hadoop.util.Progressable(){

            public void progress() {
                progress.progress();
            }
        };
    }

    public String getScheme() {
        return HOPSFS_URI_SCHEME;
    }
}

